--DROP PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueSta3n

CREATE PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueSta3n
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_ProductionAccessLogUniqueSta3n
--Server                : DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-27-2016
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Get unique stations from the access log
--==================================================================================
--Uses: NWIC_PanelMgmt.App.vNVCC_ProductionAccessLog
--Uses: CDWWork.Patient.Patient
BEGIN
	SELECT DISTINCT
		p.Sta3n,
		App.udf_StationName(p.Sta3n) AS Station
	FROM
		NWIC_PanelMgmt.App.vNVCC_ProductionAccessLog al
		INNER JOIN CDWWork.Patient.Patient p
			ON al.PatientSID = p.PatientSID
	ORDER BY Station
END
GO

exec sp_SignAppObject 'NVCC_usp_ProductionAccessLogUniqueSta3n';